/* Drop Menu */

function DropMenu(style)
{
	this.x = 0; this.y = 0;
	this.w = 80; this.h = 0;
	this.time = 0;
	this.msecs = 120;
	this.winColor = CreateColor(255, 255, 255, 0);
	this.style = style || new Style();
	this.item_height = this.style.font.getHeight();
	this.index = null;
	this.color = CreateColor(0, 0, 220, 125);
	this.items = [];
}

DropMenu.prototype.addItem = function(name, call, enabled)
{
	if (enabled == undefined) enabled = true;
	this.items.push({name: name, call: call, enabled: enabled});
	this.h += this.item_height;
}

DropMenu.prototype.blit = function()
{
	if (this.time + this.msecs > GetTime())
	{
		this.winColor.alpha = (GetTime() - this.time) * 255 / this.msecs;
		this.style.window.setColorMask(this.winColor);
	}
	else if (this.winColor.alpha != 255)
	{
		this.winColor.alpha = 255;
		this.style.window.setColorMask(this.winColor);
	}
	this.style.window.drawWindow(this.x, this.y, this.w, this.h);
	this.style.window.setColorMask(Colors.white);

	if (this.index != null) Rectangle(this.x, this.y+this.index*this.item_height, this.w, this.item_height, this.color);

	var i = this.items.length;
	while (i--)
	{
		if (!this.items[i].enabled) this.style.fontColor = Colors.gray;
		this.style.drawText(this.x+2, this.y+i*this.item_height, this.items[i].name);
		
		if (Cursor.isWithin(this.x, this.y, this.w, this.h))
		{
			if (Cursor.isWithin(this.x, this.y+i*this.item_height, this.w, this.item_height)) this.index = i;
		}
	}

	if (!Cursor.isWithin(this.x, this.y, this.w, this.h)) this.index = null;
	else
	{
		if (Cursor.leftClick() && this.items[this.index].enabled) eval(this.items[this.index].call);
	}
	this.style.fontColor = Colors.white;
}

DropMenu.prototype.enter = function()
{
	this.time = GetTime();
	this.winColor.alpha = 0;
}